/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.config.impl.ui.tiny.entry;

import java.util.function.Function;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public sealed interface TextFieldMode<T> {
    public Function<String, T> parse();

    public T min(T var1);

    public T max(T var1);

    public boolean matchesPattern(String var1);

    public double size(T var1);

    default public T parse(String input) {
        return this.parse().apply(input);
    }

    @Environment(value=EnvType.CLIENT)
    public static sealed interface Numeric<T extends Number>
    extends TextFieldMode<T> {
        public Function<Number, T> specialize();

        default public T specialize(double value) {
            return (T)((Number)this.specialize().apply(value));
        }

        @Environment(value=EnvType.CLIENT)
        public record Decimal<T extends Number>(Function<String, T> parse, Function<Number, T> specialize, T min, T max) implements Numeric<T>
        {
            private static final Pattern DECIMAL_ONLY = Pattern.compile("-?\\d*(?:\\.\\d*)?");

            @Override
            public T min(T of) {
                return this.min;
            }

            @Override
            public T max(T of) {
                return this.max;
            }

            @Override
            public boolean matchesPattern(String input) {
                return DECIMAL_ONLY.matcher(input).matches();
            }

            @Override
            public double size(T value) {
                return ((Number)value).doubleValue();
            }
        }

        @Environment(value=EnvType.CLIENT)
        public record Integer<T extends Number>(Function<String, T> parse, Function<Number, T> specialize, T min, T max) implements Numeric<T>
        {
            private static final Pattern INTEGER_ONLY = Pattern.compile("-?\\d*");

            @Override
            public T min(T of) {
                return this.min;
            }

            @Override
            public T max(T of) {
                return this.max;
            }

            @Override
            public boolean matchesPattern(String input) {
                return INTEGER_ONLY.matcher(input).matches();
            }

            @Override
            public double size(T value) {
                return ((Number)value).doubleValue();
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record Text(int min, int max) implements TextFieldMode<String>
    {
        public Text {
            min = Math.max(0, min);
            max = Math.max(max, min);
        }

        @Override
        public Function<String, String> parse() {
            return Function.identity();
        }

        @Override
        public String min(String of) {
            return of.substring(0, Math.min(of.length(), this.min)) + " ".repeat(Math.max(this.min - of.length(), 0));
        }

        @Override
        public String max(String of) {
            return of.substring(0, Math.min(of.length(), this.max)) + " ".repeat(Math.max(this.max - of.length(), 0));
        }

        @Override
        public boolean matchesPattern(String input) {
            return true;
        }

        @Override
        public double size(String value) {
            return value.length();
        }
    }
}

